/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.base.StringUtils;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.base.VWComponentManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;

class VWSocketListener
extends Thread {
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.eventlistener");
    private VWComponentManager cm = null;
    private boolean done = false;
    private String m_className = "VWSocketListener";
    private static List pool = new LinkedList();
    private boolean killed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processRequest(Socket request) {
        List list = pool;
        synchronized (list) {
            pool.add(pool.size(), request);
            pool.notifyAll();
        }
    }

    public VWSocketListener(VWComponentManager cm, int i) {
        this.cm = cm;
        this.m_className = "VWSocketListener:" + i;
        this.setName(this.m_className);
        if (logger.isFinest()) {
            logger.finest(this.m_className, "<init>", "starting..");
        }
    }

    protected void killMe() {
        this.killed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String m_method = "run";
        while (!this.killed) {
            Socket connection;
            BufferedReader socket_in = null;
            List list = pool;
            synchronized (list) {
                while (pool.isEmpty() && !this.killed) {
                    try {
                        pool.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (this.killed) {
                    break;
                }
                connection = (Socket)pool.remove(0);
            }
            try {
                socket_in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String event = null;
                do {
                    if ((event = socket_in.readLine()) == null || !event.endsWith("]") || !event.startsWith("[")) continue;
                    if (logger.isFinest()) {
                        logger.finest(this.m_className, "run", event);
                    }
                    event = event.substring(1, event.length() - 1);
                    String[] queues = StringUtils.split(event, ",");
                    this.cm.processEvent(queues);
                } while (event != null);
            }
            catch (Exception ex) {
                logger.throwing(this.m_className, "run", ex);
            }
            finally {
                if (socket_in != null) {
                    try {
                        socket_in.close();
                    }
                    catch (Exception exx) {}
                }
                try {
                    connection.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 13:36:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }
}

